'Altium Spiral Script
' Cober
' Date: Jan 6, 2014


Dim   Board
Dim   xm,ym    'mouse coordinates


Sub PlaceSpiralTrackFormCreate(Sender)

    Set Board = PCBServer.GetCurrentPCBBoard
    If Board is Nothing Then Exit Sub

    If Not Board.ChooseLocation(xm,ym,"Choose Spiral Track start location") Then
    End If

    xm = xm/10000               'convert to mils
    ym = ym/10000               '

    spr2form.Xloc.Text = xm
    spr2form.Yloc.Text = ym

   spr2form.LayerListBox.Text = Layer2String(Board.CurrentLayer)    'get current layer

    If (Board.DisplayUnit) Then
       spr2form.Metric.Checked = false
    Else
       spr2form.Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Xloc.Color = RGB(236, 233, 216 )
    Yloc.Color = RGB(236, 233, 216)
    GSpacing.Color = RGB(236, 233, 216)
    GRSpacing.Color = RGB(236, 233, 216)
    GWidth.Color = RGB(236, 233, 216)
    XCenterSpace.Color = RGB(236, 233, 216)
    YCenterSpace.Color = RGB(236, 233, 216)
    Turns.Color = RGB(236, 233, 216)
    ViaDia.Color = RGB(236, 233, 216)
    Drill.Color = RGB(236, 233, 216)

End Sub


Sub XPBitBtn1Click(Sender)
    Dim   Layer, Spacing, RSpacing, Width
    Dim   Via
    Dim   CenterX, CenterY


    If (Board.DisplayUnit) Then
       Metric.Checked = false
    Else
       Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Width = (spr2form.GWidth.Text)
    Spacing = (spr2form.GSpacing.Text)
    RSpacing = (spr2form.GRSpacing.Text)

    Layer = String2Layer(LayerListBox.Text)

    if (Width < 0) or (Spacing < 0) then
       showmessage ("Negative Value entered; results may not be good...")
    end if

    spr2form.Hide

    PCBServer.PreProcess

    'move everything to Mils
    if (Metric.Checked) Then
         MetricClick
         Metric.Checked = false
    end if

    CenterX = XLoc.Text
    CenterY = YLoc.Text

    If XPCheckBox_via.Checked Then
        'Place Via
        Via           = PCBServer.PCBObjectFactory(eViaObject, eNoDimension, eCreate_Default)
        Via.X         = MilsToCoord(CenterX)
        Via.Y         = MilsToCoord(CenterY)
        Via.Size      = MilsToCoord(ViaDia.Text)
        Via.HoleSize  = MilsToCoord(Drill.Text)
        Via.LowLayer  = eTopLayer
        Via.HighLayer = eBottomLayer
        Board.AddPCBObject(Via)
    End If

   Make_RSpiral Board, Layer, CenterX, CenterY, Turns.Text, Width, Spacing, RSpacing, XCenterSpace.Text, YCenterSpace.Text, XPCheckBox_CCW.Checked

   PCBServer.PostProcess
    ' Refresh PCB workspace.
    ResetParameters
    Call AddStringParameter("Action", "Redraw")
    RunProcess("PCB:Zoom")

  Close
End Sub



'make a non-linear spiral; the non-linear portion is towards right
sub Make_RSpiral (Board, Layer, CenterX, CenterY, NumTurns, TraceWidth, Spacing, Rspacing, CspaceX, CspaceY, CClockwise)

    Dim Arc
    Dim Track
    Dim LSide_inc      ' also Top/Bottom increment
    Dim RSide_inc
    Dim Xlength
    Dim Ylength

'showmessage ("centerx=" & CenterX & " Width=" & width)
    LSide_inc = (Spacing/1.0 + TraceWidth/1.0)
    RSide_inc = RSpacing/1.0
    Xlength = TraceWidth/2.0 + CspaceX/ 2.0
    Ylength = TraceWidth/2.0 + CspaceY/ 2.0
    
    'Add a trace from center
    Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
    Track.y1 = MilsToCoord(CenterY)
    Track.x1 = MilsToCoord(CenterX)
    Track.x2 = MilsToCoord(CenterX)
    Track.y2 = MilsToCoord(CenterY - Ylength)
    Track.Width = MilsToCoord (TraceWidth)
    Track.Layer = Layer
    Board.AddPCBObject(Track)

    FOR idx = 0 TO NumTurns -1

        'Bottom Side run: pt1 = bottom left; pt2 = bottom right
        Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
        if (CClockwise) then
           Track.x1 = MilsToCoord(CenterX - Xlength)
           Track.x2 = MilsToCoord(CenterX + Xlength+ idx * RSide_inc - RSide_inc - LSide_inc)
           if (idx = 0) then   'first trace stops at middle
               Track.x2 = MilsToCoord(CenterX)
           end if
        else
           Track.x1 = MilsToCoord(CenterX - Xlength + LSide_inc)
           Track.x2 = MilsToCoord(CenterX + Xlength + idx * RSide_inc)
           if (idx = 0) then   'first trace starts at middle
               Track.x1 = MilsToCoord(CenterX)
           end if
        end if
        Track.y1 = MilsToCoord(CenterY - Ylength)
        Track.y2 = MilsToCoord(CenterY - Ylength)
        Track.Width = MilsToCoord (TraceWidth)
        Track.Layer = Layer
        Board.AddPCBObject(Track)

        'Right Side Run: pt1 = bottom right; pt2 = top right
        Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
        if (CClockwise) then
            Track.y1 = MilsToCoord(CenterY - Ylength - LSide_inc)
        else
            Track.y1 = MilsToCoord(CenterY - Ylength)
        end if
        Track.x1 = MilsToCoord(CenterX + Xlength + idx * RSide_inc)
        Track.x2 = MilsToCoord(CenterX + Xlength + idx * RSide_inc)
        Track.y2 = MilsToCoord(CenterY + Ylength)
        Track.Width = MilsToCoord (TraceWidth)
        Track.Layer = Layer
        Board.AddPCBObject(Track)

        'Top Side Run: pt1 = top right; pt2 = top left
        Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
        Track.x1 = MilsToCoord(CenterX + Xlength + idx * Rside_inc)
        Track.y1 = MilsToCoord(CenterY + Ylength)
        Track.x2 = MilsToCoord(CenterX - Xlength)
        Track.y2 = MilsToCoord(CenterY + Ylength)
        Track.Width = MilsToCoord (TraceWidth)
        Track.Layer = Layer
        Board.AddPCBObject(Track)

        'Left Side Run: pt1 = top left; pt2 = bottom left
        Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
        if (CClockwise) then
            Track.y2 = MilsToCoord(CenterY - Ylength)
        else
            Track.y2 = MilsToCoord(CenterY - Ylength - LSide_inc)
        end if
        Track.x1 = MilsToCoord(CenterX - Xlength)
        Track.y1 = MilsToCoord(CenterY + Ylength)
        Track.x2 = MilsToCoord(CenterX - Xlength)
        Track.Width = MilsToCoord (TraceWidth)
        Track.Layer = Layer
        Board.AddPCBObject(Track)

        Xlength = Xlength + LSide_inc
        Ylength = Ylength + LSide_inc
    Next

    'Add a final trace
    Track = PCBServer.PCBObjectFactory(eTrackObject,eNoDimension, eCreate_Default)
    Track.y1 = MilsToCoord(CenterY - Ylength)
    Track.x1 = MilsToCoord(CenterX)
    if (CClockwise) then
        Track.x2 = MilsToCoord(CenterX + Xlength - LSide_inc + (NumTurns -1) *RSide_inc )
    else
        Track.x2 = MilsToCoord(CenterX - Xlength + LSide_inc)
    end if
    Track.y2 = MilsToCoord(CenterY - Ylength)
    Track.Width = MilsToCoord (TraceWidth)
    Track.Layer = Layer
    Board.AddPCBObject(Track)


End Sub   'Make_Spiral()




Sub Main
     spr2form.showmodal
End Sub

Sub XPBitBtn2Click(Sender)
    close
End Sub

Sub MetricClick(Sender)
    If Metric.Checked Then
          Xloc.Text = (Xloc.Text * 0.0254)
          Yloc.Text = (Yloc.Text * 0.0254)
          ViaDia.Text = (ViaDia.Text * 0.0254)
          Drill.Text = (Drill.Text * 0.0254)
          GSpacing.Text = (GSpacing.Text * 0.0254)
          GRSpacing.Text = (GRSpacing.Text * 0.0254)
          GWidth.Text = (GWidth.Text * 0.0254)
          XCenterSpace.Text = (XCenterSpace.Text * 0.0254)
          YCenterSpace.Text = (YCenterSpace.Text * 0.0254)
          Label10.Caption = "mm"
          Label11.Caption = "mm"
          Label12.Caption = "mm"
          Label13.Caption = "mm"
          Label14.Caption = "mm"
          Label15.Caption = "mm"
          Label18.Caption = "mm"
    Else
          Xloc.Text = (Xloc.Text / 0.0254)
          Yloc.Text = (Yloc.Text / 0.0254)
          ViaDia.Text = (ViaDia.Text / 0.0254)
          Drill.Text = (Drill.Text / 0.0254)
          GSpacing.Text = (GSpacing.Text / 0.0254)
          GRSpacing.Text = (GRSpacing.Text / 0.0254)
          GWidth.Text = (GWidth.Text / 0.0254)
          XCenterSpace.Text = (XCenterSpace.Text / 0.0254)
          YCenterSpace.Text = (YCenterSpace.Text / 0.0254)
          Label10.Caption = "mil"
          Label11.Caption = "mil"
          Label12.Caption = "mil"
          Label13.Caption = "mil"
          Label14.Caption = "mil"
          Label15.Caption = "mil"
          Label18.Caption = "mil"
    End If
End Sub




